#lang scribble/manual
@(require (for-label scribble/struct
                     scriblib/footnote
                     racket/base
                     racket/contract))

@title[#:tag "footnotes"]{Footnotes}

@defmodule[scriblib/footnote]

@defproc[(note [pre-content pre-content?] ...) element?]{

Creates a margin note for HTML and a footnote for Latex/PDF output.

To produce a numbered note for HTML (which can useful if a CSS
specialization changes how ``margin notes'' are rendered), use
@racket[define-footnote] with @racket[#:margin], instead.

The element generated by @racket[note] uses the style
@racket["NoteBox"] wrapped around an element using the style
@racket["NoteContent"]. CSS and Latex macros configure rendering for
HTML and Latex/PDF to create a margin note or footnote, but those CSS
classes or Latex macros can be redefined or overridden to produce a
different result.

}

@defform*[((define-footnote footnote-id footnote-part-id)
           (define-footnote footnote-id #:margin))]{

Binds @racket[footnote-id] to a form like @racket[note] that registers
a footnote. For Latex/PDF output, this is the same result as using
@racket[note].

If @racket[footnote-part-id] is provided, it is bound to a function
that generates a section to display the registered footnotes in HTML.
The section generated by @racket[footnote-part-id] will not show a title or
appear in a table of contents; it will look like a footnote area.
If @racket[#:margin] is supplied instead, then each footnote is
rendered as an immediate margin note, and no separate footnote section
is needed.

Using @racket[footnote-id] within the argument to a
@racket[footnote-id] will not always work, but it can work in
@racket[#:margin] mode for HTML output.

Example:
@codeblock|{
  #lang scribble/manual
  @require[scriblib/footnote]

  @define-footnote[my-note make-my-note]

  @title{Months of the Year}

  @section{January}
  January has 31 days.

  @section{February}
  February has 28 days in common years.@my-note{In leap years,
  February has 29 days.}

  @make-my-note[]

  @section{March}
  March has 30 days.
}|


The elements and parts generated by @racket[footnote-id] and
@racket[footnote-part-id] use the following style names, which can be
redefined as CSS classes or Latex macros to adjust the result:

@itemlist[

 @item{@racket["Footnote"]: Style for the result of
 @racket[footnote-id], which is mapped to @tt{\footnote} for Latex.}

 @item{@racket["FootnoteRef"]: Wrapped around the reference to a
 footnote that is rendered by @racket[footnote-part-id] or as a margin
 note. For Latex, this name is mapped to a macro that returns nothing,
 leaving the reference managment to @tt{\footnote}.}

 @item{@racket["FootnoteRefNumber"]: Wrapped around the footnote
 number as a reference (inside of @racket["FootnoteRef"]), so that the
 default superscript style for a footnote reference can be changed for
 HTML output (or potentially for Latex, if @racket["Footnote"] is not
 mapped to @tt{\footnote}).}

 @item{@racket["FootnoteTarget"]: Wrapped around the footnote that is
 rendered by @racket[footnote-part-id] or as a margin note. For Latex,
 this name is mapped to a macro that returns nothing, leaving the
 reference managment to @tt{\footnote}.}

 @item{@racket["FootnoteTargetNumber"]: Wrapped around the footnote
 number rendered by @racket[footnote-part-id] or as a margin note, so
 that the default superscript style within a footnote can be changed
 for HTML (or potentially for Latex, if @racket["Footnote"] is not
 mapped to @tt{\footnote}).}

 @item{@racket["FootnoteContent"]: For Latex, wrapped around the
 content of a footnote as rendered by @racket[footnote-part-id].}

 @item{@racket["FootnoteMarginContent"]: Wrapped around the content of
 a footnote as rendered as a margin note. By default, CSS styling for
 this name floats the note into the right margin.}

 @item{@racket["FootnoteBlock"]: Wrapped around the output of
 @racket[footnote-part-id].}

 @item{@racket["FootnoteBlockContent"]: Also wrapped around the output of
 @racket[footnote-part-id], inside the @racket["FootnoteBlock"] wrapper.}

]

}
